!OPT_SYS.zpl
! Calculate SYSTEM DATA
! Written by Sergey M. Kozlovsky 07/10/2007
! E-mail: kcmo@TUT.BY

FILE$  = $FILEPATH()
TITLE$ = $LENSNAME()
data$ = $DATE()
PRINT
PRINT "Date : ", DATA$
PRINT "File : ", FILE$
PRINT "Title: ", TITLE$
PRINT
PRINT "DESIGN DATA OF OPTICAL SYSTEM",
L = 1000*WAVL(PWAV())
FORMAT .4
PRINT "                 Lo = ",L," nm"
PRINT
PRINT "Surf      Radius    Thickness    Diameter    Glass     Index      Conic"
PRINT "--------------------------------------------------------------------------"
n = NSUR()
GETSYSTEMDATA 1
st = VEC1(23)
FOR s = 1, n, 1
   D = 2*SDIA(s)
   R = RADI(s)
   T = THIC(s)
   i = INDX(s)
   c = CONI(s)
   Gl$ = $GLASS(s) 
   IF (s == st)
      PRINT " STO",
   ELSE
     IF (s == n)
        PRINT " IMA",
     ELSE
        FORMAT 4.0
        PRINT s,
     ENDIF
   ENDIF
 
   FORMAT 12.4
   PRINT " ",R,
   FORMAT 11.3
   PRINT " ",T," ",D,
   Gl$ = $RIGHTSTRING(Gl$, 8) 
   PRINT " ",Gl$,
   FORMAT 9.6
   PRINT "  ",i,
   FORMAT 9.5
   IF ( != 0)
     PRINT "  ",c
     else
     PRINT "  "
   ENDIF
NEXT

PRINT "--------------------------------------------------------------------------"
PRINT "        F'            Sf            Sf'           SH            SH'  "
FOR s = 1, n, 1
  i = INDX(s)
  IF (i != 1)
   K1= S
   GOTO 1
  ENDIF
NEXT
LABEL 1
!K1 = 1
K2 = n-1 
RAB = 1
GOSUB FOCUS
SH = POT-FOP
SH1 = ZOT-FOK
FORMAT 13.4
PRINT  FOK, " ",POT," ",ZOT," ",SH," ",SH1
PRINT "--------------------------------------------------------------------------"
PRINT "  Pupil     Diameter     Position"
FORMAT 10.3
PRINT "Entrance :",VEC1(11),
FORMAT 12.3
PRINT " ",VEC1(12)
FORMAT 10.3
PRINT "Exit     :",VEC1(13),
FORMAT 12.3
PRINT " ",VEC1(14)
PRINT "--------------------------------------------------------------------------"
FORMAT 9.3
PRINT "Working F/# :",VEC1(10),
PRINT "       Total Track :",VEC1(18)

FORMAT 12.3
PRINT "Magnification : Paraxial ",VEC1(16),
FORMAT 12.3
PRINT "; Angular ",VEC1(17),";"
MF = NFLD()
FORMAT 10.3
PRINT "Height Field ",
tp = FTYP()
IF (tp == 0)
   PRINT "(degr)",
ELSE
  PRINT "( mm )",
ENDIF
FOR I = 1, MF, 1
  PRINT FLDY(i),
NEXT
PRINT
PRINT "Vignetting Field : ",
FOR I = 1, MF, 1
  PRINT FVCY(i),
NEXT

END
!-------------------------------------------------
SUB FOCUS
  FOR j= K1, K2, 1 
    VEC4(j)= SIGN(THIC(j))*INDX(j)
    if (VEC4(j) == 0)
      VEC4(j)= 1E-12
    endif 
  NEXT
  G11 = 1.0
  G12 = 0.0
  G21 = 0.0
  G22 = 1.0
  DM = 0.0
  FOR I = K1, K2, 1
    G11 = G11 - DM * G21 
    G12 = G12 - DM * G22 
    if (RAB == 1) & (I == K1) 
      M = 1/VEC4(I)
    ELSE
      if (RAB == 1) & (I == K2) 
      M = VEC4(I-1)
      else
      M = VEC4(I-1)/VEC4(I)
      endif
    ENDIF
    IF (RADI(I) == 0)
      RO = 0.0
    ELSE
      RO = 1/RADI(I)
    ENDIF
    AL = RO * (1 - M)
    DM = THIC(I)
    G21 = G21 * M + AL * G11 
    G22 = G22 * M + AL * G12 
  NEXT
  IF (G21 == 0)
    FOK = 0.0
    ZOT = 0.0
    FOP = 0.0
    POT = 0.0
  ELSE
    FOK = 1 / G21
    ZOT = G11 / G21
    FOP = G12- (G11*G22/ G21)
    POT = - (G22/ G21)
  ENDIF
RETURN





